var gameResources = [
   "assets/cover.png",
   "assets/tile_0.png",
   "assets/tile_1.png",
   "assets/tile_2.png",
   "assets/tile_3.png",
   "assets/tile_4.png",
   "assets/tile_5.png",
   "assets/tile_6.png",
   "assets/tile_7.png"
];

var gameArray = [
                 [0,0,1,1],
				 [2,2,3,3],
				 [4,4,5,5],
				 [6,6,7,7]
				];
				
var pickedTiles = [];		


var listener = cc.EventListener.create({

    event:cc.EventListener.TOUCH_ONE_BY_ONE,
	swallowTouches:true,
	onTouchBegan: function(touch,event) {
	
	  if(pickedTiles.length < 2) {
	
	    var target = event.getCurrentTarget();
		var location = target.convertToNodeSpace(touch.getLocation());
		var targetSize = target.getContentSize();
		var targetRect = cc.rect(0,0,targetSize.width,targetSize.height);
		
		if(cc.rectContainsPoint(targetRect, location)) {
		
		   if(pickedTiles.indexOf(target) == -1) {
		      
			  console.log("I picked a tile");
		      target.initWithFile("assets/tile_" + target.value + ".png");
			 
			  pickedTiles.push(target);
			  if(pickedTiles.length == 2)  {
			  
			     if(pickedTiles[0].value == pickedTiles[1].value) {
				 
				   setTimeout(function() {
				   
					  background.removeChild(pickedTiles[0]);
					  background.removeChild(pickedTiles[1]);
					  pickedTiles = [];
						
				   },500);
				 
				 } else { 
				 
				   setTimeout(function(){
				     
					  pickedTiles[0].initWithFile("assets/cover.png");
					  pickedTiles[1].initWithFile("assets/cover.png");
				      pickedTiles = [];
				   
				   },1000);
				 }			  
			  }
		     
		   }
		
		}
	  }
	}
});

var mytile = cc.Sprite.extend({
  
    ctor:function(){
	
	   this._super();
	   this.initWithFile("assets/cover.png");
	   
	   cc.eventManager.addListener(listener.clone(),this);
	}
	
});

var background;

var mylayer = cc.Layer.extend({

   init:function(){
        this._super();
		background = cc.LayerColor.create(cc.color(0,0,256,128));
		
		this.addChild(background);
		
		for(var i=0; i<4; i++) {
		   for(var j=0; j<4; j++) {
		
			   tile = new mytile();
			   tile.value = gameArray[i][j];
			   tile.setPosition(i*80+40,j*80+150);
			   background.addChild(tile,0);
		   }
		}
   }
});

var myscene = cc.Scene.extend({

   onEnter:function(){
       
	    this._super();
		var layer1 = new mylayer();
		layer1.init();
		this.addChild(layer1);
   }
});







